
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("hoodie_profit")

# Create variables
zippered = m.addVar(vtype=GRB.INTEGER, name="zippered")
pullover = m.addVar(vtype=GRB.INTEGER, name="pullover")

# Set objective function
m.setObjective(5 * zippered + 4 * pullover, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * zippered + 15 * pullover <= 450, "budget")
m.addConstr(zippered + pullover <= 25, "total_hoodies")
m.addConstr(zippered >= 0, "zippered_non_negative")
m.addConstr(pullover >= 0, "pullover_non_negative")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of zippered hoodies: {zippered.x}")
    print(f"Number of pullover hoodies: {pullover.x}")
elif m.status == GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

