
from gurobipy import *

# Create a new model
m = Model("hoodies")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="zippered_hoodies")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="pullover_hoodies")

# Set the objective function
m.setObjective(5*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 15*x2 <= 450, "total_cost")
m.addConstr(x1 + x2 <= 25, "total_hoodies")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of zippered hoodies: {x1.x}")
    print(f"Number of pullover hoodies: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
