
import gurobi

def solve_hoodie_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="zippered_hoodies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="pullover_hoodies", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5*x1 + 4*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20*x1 + 15*x2 <= 450, name="budget_constraint")
    model.addConstr(x1 + x2 <= 25, name="total_hoodies_constraint")
    model.addConstr(x1 >= 0, name="non_negative_x1")
    model.addConstr(x2 >= 0, name="non_negative_x2")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_hoodie_problem()
