
import gurobipy as gp

# Create a new model
m = gp.Model("chair_production")

# Create variables
office_chairs = m.addVar(vtype=gp.GRB.INTEGER, name="office_chairs")
dining_chairs = m.addVar(vtype=gp.GRB.INTEGER, name="dining_chairs")

# Set objective function
m.setObjective(120 * office_chairs + 180 * dining_chairs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(200 * office_chairs + 250 * dining_chairs <= 20000, "cost_constraint")
m.addConstr(office_chairs + dining_chairs <= 130, "demand_constraint")
m.addConstr(office_chairs >= 0, "office_chairs_nonnegative")
m.addConstr(dining_chairs >= 0, "dining_chairs_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of office chairs: {office_chairs.x}")
    print(f"Number of dining chairs: {dining_chairs.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

