
from gurobipy import *

# Create a new model
m = Model("chair_optimization")

# Create variables
x1 = m.addVar(name="office_chairs", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="dining_chairs", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(120*x1 + 180*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(200*x1 + 250*x2 <= 20000, name="budget_constraint")
m.addConstr(x1 + x2 <= 130, name="demand_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Office chairs: {x1.x}")
    print(f"Dining chairs: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
