
import gurobipy as gp

# Create a new model
model = gp.Model("Leeside_Designs_Chair_Optimization")

# Define the variables
x1 = model.addVar(name="office_chairs", lb=0, vtype=gp.GRB.INTEGER)  # Number of office chairs
x2 = model.addVar(name="dining_chairs", lb=0, vtype=gp.GRB.INTEGER)  # Number of dining chairs

# Objective function: Maximize profit
model.setObjective(120*x1 + 180*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(200*x1 + 250*x2 <= 20000, name="investment_constraint")  # Investment constraint
model.addConstr(x1 + x2 <= 130, name="demand_constraint")  # Demand constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Office chairs: {x1.varValue}, Dining chairs: {x2.varValue}")
else:
    print("No optimal solution found.")
