
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Nolan_Center_Concert")

# Create variables
vip_tickets = m.addVar(lb=0, vtype=GRB.INTEGER, name="vip_tickets")
general_tickets = m.addVar(lb=0, vtype=GRB.INTEGER, name="general_tickets")

# Set objective function
m.setObjective(30 * vip_tickets + 14 * general_tickets, GRB.MAXIMIZE)

# Add constraints
m.addConstr(vip_tickets + general_tickets <= 200, "Total seating capacity")
m.addConstr(vip_tickets >= 20, "Minimum VIP seats")
m.addConstr(general_tickets >= 4 * vip_tickets, "General vs VIP preference")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of VIP tickets: {vip_tickets.x}")
    print(f"Number of general tickets: {general_tickets.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

