
from gurobipy import *

# Create a new model
m = Model("Concert_Seating")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="VIP_seats")
x2 = m.addVar(vtype=GRB.INTEGER, name="General_seats")

# Set objective function
m.setObjective(30*x1 + 14*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 200, "Total_Seats")
m.addConstr(x1 >= 20, "Minimum_VIP")
m.addConstr(x2 >= 4*x1, "General_vs_VIP")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"VIP seats: {x1.x}")
    print(f"General seats: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
