
import gurobi

def nolan_center_concert():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="VIP_seats")
    x2 = model.addVar(lb=0, name="general_seats")

    # Objective function: maximize 30*x1 + 14*x2
    model.setObjective(30*x1 + 14*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 200, name="total_seats")
    model.addConstr(x1 >= 20, name="min_VIP_seats")
    model.addConstr(x2 >= 4*x1, name="general_vs_VIP")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"VIP seats: {x1.varValue}")
        print(f"General seats: {x2.varValue}")
        print(f"Max Profit: {30*x1.varValue + 14*x2.varValue}")
    else:
        print("No optimal solution found.")

nolan_center_concert()
