
import gurobipy as gp

# Create a new model
m = gp.Model("furniture_production")

# Create variables
desks_X = m.addVar(vtype=gp.GRB.CONTINUOUS, name="desks_X") # desks made by manufacturer X
chairs_Y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chairs_Y") # chairs made by manufacturer Y


# Set objective function
m.setObjective(140 * desks_X + 120 * chairs_Y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(desks_X <= 22, "manufacturer_X_capacity")
m.addConstr(chairs_Y <= 28, "manufacturer_Y_capacity")
m.addConstr(desks_X + chairs_Y <= 40, "quality_check_capacity")
m.addConstr(desks_X >=0)
m.addConstr(chairs_Y >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of desks from Manufacturer X: {desks_X.x}")
    print(f"Number of chairs from Manufacturer Y: {chairs_Y.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

