
from gurobipy import *

# Create a new model
m = Model("Furniture_Optimization")

# Define variables
x1 = m.addVar(name="desks_by_X", lb=0)  # Number of desks made by Manufacturer X
x2 = m.addVar(name="chairs_by_Y", lb=0)  # Number of chairs made by Manufacturer Y

# Set the objective function
m.setObjective(140*x1 + 120*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 22, name="max_desks_X")
m.addConstr(x2 <= 28, name="max_chairs_Y")
m.addConstr(x1 + x2 <= 40, name="quality_check_limit")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Desks made by Manufacturer X: {x1.x}")
    print(f"Chairs made by Manufacturer Y: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
