
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, ub=22, name="desks_from_Manufacturer_X")
    x2 = model.addVar(lb=0, ub=28, name="chairs_from_Manufacturer_Y")

    # Set the objective function
    model.setObjective(140 * x1 + 120 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 22, name="desks_limit")
    model.addConstr(x2 <= 28, name="chairs_limit")
    model.addConstr(x1 + x2 <= 40, name="quality_check_limit")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of desks to make: {x1.varValue}")
        print(f"Number of chairs to make: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
