
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("burrito_optimization")

    # Create variables
    bean_burritos = m.addVar(vtype=gp.GRB.INTEGER, name="bean_burritos")
    beef_burritos = m.addVar(vtype=gp.GRB.INTEGER, name="beef_burritos")

    # Set objective function
    m.setObjective(6.5 * bean_burritos + 9 * beef_burritos, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(25 * bean_burritos + 18 * beef_burritos <= 5000, "lettuce_constraint")
    m.addConstr(beef_burritos >= 4 * bean_burritos, "beef_demand_constraint")
    m.addConstr(bean_burritos >= 5, "min_bean_constraint")


    # Optimize model
    m.optimize()

    # Print results
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))

    print('Obj: %g' % m.objVal)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

