
import gurobipy as gp

def solve_burrito_problem():
    # Create a new model
    model = gp.Model("Burrito_Problem")

    # Define variables
    x1 = model.addVar(name="bean_burritos", lb=5, vtype=gp.GRB.INTEGER)  # At least 5 bean burritos
    x2 = model.addVar(name="beef_burritos", vtype=gp.GRB.INTEGER)  # No lower bound, but constrained by others

    # Objective function: Maximize profit
    model.setObjective(6.5 * x1 + 9 * x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(25 * x1 + 18 * x2 <= 5000, name="Lettuce_Constraint")
    model.addConstr(x2 >= 4 * x1, name="Demand_Constraint")

    # Solve the problem
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: Bean Burritos = {x1.varValue}, Beef Burritos = {x2.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_burrito_problem()
