
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Teabag Optimization")

# Create variables
earl_grey = m.addVar(vtype=GRB.INTEGER, name="earl_grey")
english_breakfast = m.addVar(vtype=GRB.INTEGER, name="english_breakfast")

# Set objective function
m.setObjective(0.30 * earl_grey + 0.25 * english_breakfast, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * earl_grey + 20 * english_breakfast <= 3000, "Black Tea Constraint")
m.addConstr(earl_grey >= 4 * english_breakfast, "Demand Constraint")
m.addConstr(english_breakfast >= 20, "Minimum English Breakfast Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"  Earl Grey Teabags: {earl_grey.x}")
    print(f"  English Breakfast Teabags: {english_breakfast.x}")
    print(f"  Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

