
from gurobipy import *

# Create a new model
m = Model("Tea_Production")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Earl_Grey")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="English_Breakfast")

# Set objective function
m.setObjective(0.30*x1 + 0.25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25*x1 + 20*x2 <= 3000, "Black_Tea_Availability")
m.addConstr(x1 >= 4*x2, "Demand_Constraint")
m.addConstr(x2 >= 20, "Minimum_English_Breakfast")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Earl Grey teabags:", x1.x)
    print("English Breakfast teabags:", x2.x)
else:
    print("No optimal solution found")
