
import gurobi

def solve_tea_bag_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='earl_grey', lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='english_breakfast', lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(0.30 * x1 + 0.25 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(25 * x1 + 20 * x2 <= 3000, name='black_tea_availability')
    model.addConstr(x1 >= 4 * x2, name='earl_grey_demand')
    model.addConstr(x2 >= 20, name='english_breakfast_min')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: earl grey = {x1.varValue}, english breakfast = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_tea_bag_problem()
