
import gurobipy as gp

# Create a new model
m = gp.Model("soup_optimization")

# Create variables
crab_soup = m.addVar(vtype=gp.GRB.CONTINUOUS, name="crab_soup")  # x1
lobster_soup = m.addVar(vtype=gp.GRB.CONTINUOUS, name="lobster_soup")  # x2

# Set objective function
m.setObjective(3 * crab_soup + 5 * lobster_soup, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * crab_soup + 10 * lobster_soup <= 80, "water_constraint")
m.addConstr(8 * crab_soup <= 65, "crab_meat_constraint")
m.addConstr(5 * lobster_soup <= 55, "lobster_meat_constraint")
m.addConstr(crab_soup >= 0, "crab_soup_nonnegativity")  # Explicit non-negativity constraint
m.addConstr(lobster_soup >= 0, "lobster_soup_nonnegativity")  # Explicit non-negativity constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Servings of crab soup: {crab_soup.x}")
    print(f"Servings of lobster soup: {lobster_soup.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

