
from gurobipy import *

# Create a new model
m = Model("soup_profit_maximization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="crab_soup_servings")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="lobster_soup_servings")

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 10*x2 <= 80, "water_constraint")
m.addConstr(8*x1 <= 65, "crab_meat_constraint")
m.addConstr(5*x2 <= 55, "lobster_meat_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Crab soup servings: {x1.x}")
    print(f"Lobster soup servings: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
