
import gurobi

def solve_soup_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='crab_soup', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='lobster_soup', lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(7*x1 + 10*x2 <= 80, name='water_constraint')
    model.addConstr(8*x1 <= 65, name='crab_meat_constraint')
    model.addConstr(5*x2 <= 55, name='lobster_meat_constraint')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Quantity of crab soup: {x1.varValue}')
        print(f'Quantity of lobster soup: {x2.varValue}')
        print(f'Maximum profit: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_soup_problem()
