
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("wood_shop")

# Create variables
cutting_boards = m.addVar(vtype=GRB.CONTINUOUS, name="cutting_boards")  # x1
knife_handles = m.addVar(vtype=GRB.CONTINUOUS, name="knife_handles")  # x2


# Set objective function
m.setObjective(100 * cutting_boards + 250 * knife_handles, GRB.MAXIMIZE)

# Add constraints
m.addConstr(cutting_boards <= 30, "cutting_board_limit")
m.addConstr(knife_handles <= 50, "knife_handle_limit")
m.addConstr(5 * cutting_boards + 10 * knife_handles <= 200, "labor_limit")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Cutting boards: {cutting_boards.x:.2f}")
    print(f"Knife handles: {knife_handles.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

