
from gurobipy import *

# Create a new model
m = Model("WoodShop")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cutting_boards")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="knife_handles")

# Set the objective function
m.setObjective(100*x1 + 250*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 30, "max_cutting_boards")
m.addConstr(x2 <= 50, "max_knife_handles")
m.addConstr(5*x1 + 10*x2 <= 200, "total_hours")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cutting Boards: {x1.x}")
    print(f"Knife Handles: {x2.x}")
    print(f"Total Profit: ${100*x1.x + 250*x2.x:.2f}")
else:
    print("No optimal solution found")
