
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=30, name="cutting_boards")
    x2 = model.addVar(lb=0, ub=50, name="knife_handles")

    # Set objective function
    model.setObjective(100 * x1 + 250 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 30, name="cutting_boards_limit")
    model.addConstr(x2 <= 50, name="knife_handles_limit")
    model.addConstr(5 * x1 + 10 * x2 <= 200, name="total_hours_limit")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cutting boards: {x1.varValue}")
        print(f"Knife handles: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
