
import gurobipy as gp

# Create a new model
m = gp.Model("seafood_processing")

# Create variables
crab = m.addVar(vtype=gp.GRB.CONTINUOUS, name="crab")
lobster = m.addVar(vtype=gp.GRB.CONTINUOUS, name="lobster")

# Set objective function
m.setObjective(14 * crab + 18 * lobster, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * crab + 5 * lobster <= 400, "cleaning_time")
m.addConstr(15 * crab + 12 * lobster <= 900, "shelling_time")
m.addConstr(crab >= 0, "non_negative_crab")
m.addConstr(lobster >= 0, "non_negative_lobster")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of crabs to process: {crab.x:.2f}")
    print(f"Number of lobsters to process: {lobster.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

