
from gurobipy import *

# Create a new model
m = Model("Crab_Lobster_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="crabs", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="lobsters", lb=0)

# Set the objective function
m.setObjective(14*x1 + 18*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 5*x2 <= 400, "cleaning_time")
m.addConstr(15*x1 + 12*x2 <= 900, "shelling_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of crabs: {x1.x}")
    print(f"Number of lobsters: {x2.x}")
    print(f"Maximum profit: ${14*x1.x + 18*x2.x:.2f}")
else:
    print("No optimal solution found")
