
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='crabs', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='lobsters', lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(14*x1 + 18*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(4*x1 + 5*x2 <= 400, name='cleaning_constraint')
    model.addConstr(15*x1 + 12*x2 <= 900, name='shelling_constraint')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of crabs: {x1.varValue}")
        print(f"Optimal number of lobsters: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
