
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("oil_production")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="economical")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="premium")


# Set objective function
m.setObjective(500 * x1 + 1020 * x2 + 920 * x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * x1 + 5 * x2 + 8 * x3 <= 200, "compound_A")
m.addConstr(2 * x1 + 1 * x2 + 1 * x3 <= 100, "compound_B")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {m.objVal}")
    print(f"Economical: {x1.x}")
    print(f"Regular: {x2.x}")
    print(f"Premium: {x3.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

