
from gurobipy import *

# Create a model
m = Model("Oil_Production")

# Define variables
x1 = m.addVar(name="economical", lb=0)
x2 = m.addVar(name="regular", lb=0)
x3 = m.addVar(name="premium", lb=0)

# Set the objective function
m.setObjective(500*x1 + 1020*x2 + 920*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 5*x2 + 8*x3 <= 200, name="compound_A")
m.addConstr(2*x1 + x2 + x3 <= 100, name="compound_B")

# Optimize the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print("Objective:", m.objVal)
