
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
apple_acres = m.addVar(name="apple_acres")
peach_acres = m.addVar(name="peach_acres")

# Set objective function
m.setObjective(900 * apple_acres + 1100 * peach_acres, GRB.MAXIMIZE)

# Add constraints
m.addConstr(apple_acres + peach_acres <= 400, "total_acres")
m.addConstr(apple_acres >= 60, "min_apple")
m.addConstr(peach_acres >= 40, "min_peach")
m.addConstr(peach_acres <= 3 * apple_acres, "peach_apple_ratio")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal profit: ${m.objVal}")
    print(f"Plant {apple_acres.x} acres of apple trees.")
    print(f"Plant {peach_acres.x} acres of peach trees.")

