
import gurobipy as gp

# Create a new model
m = gp.Model("farmer")

# Define variables
x1 = m.addVar(name="apple_trees", lb=0)  # acres of apple trees
x2 = m.addVar(name="peach_trees", lb=0)  # acres of peach trees

# Objective function: Maximize profit
m.setObjective(900*x1 + 1100*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 400, name="total_land")  # Total land constraint
m.addConstr(x1 >= 60, name="min_apple_trees")  # Minimum apple trees
m.addConstr(x2 >= 40, name="min_peach_trees")  # Minimum peach trees
m.addConstr(x2 <= 3*x1, name="peach_to_apple_ratio")  # Peach to apple ratio

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
  print(f"Optimal solution: Acres of apple trees = {x1.varValue}, Acres of peach trees = {x2.varValue}")
  print(f"Maximum profit: ${900*x1.varValue + 1100*x2.varValue}")
else:
  print("No optimal solution found")
