
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("hockey_vendor")

# Create variables
coffees = m.addVar(lb=0, vtype=GRB.INTEGER, name="coffees")
hot_chocolates = m.addVar(lb=0, vtype=GRB.INTEGER, name="hot_chocolates")


# Set objective function
m.setObjective(0.22 * coffees + 0.14 * hot_chocolates, GRB.MAXIMIZE)

# Add constraints
m.addConstr(coffees >= 40, "min_coffees")
m.addConstr(hot_chocolates >= 20, "min_hot_chocolates")
m.addConstr(coffees <= 60, "max_coffees")
m.addConstr(hot_chocolates <= 35, "max_hot_chocolates")
m.addConstr(coffees + hot_chocolates <= 75, "max_total")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of coffees to sell: {coffees.x}")
    print(f"Number of hot chocolates to sell: {hot_chocolates.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

