
from gurobipy import *

# Create a new model
m = Model("Coffee_HotChocolate_Problem")

# Define variables
x1 = m.addVar(lb=40, ub=60, vtype=GRB.INTEGER, name="coffees")
x2 = m.addVar(lb=20, ub=35, vtype=GRB.INTEGER, name="hot_chocolates")

# Set the objective function
m.setObjective(0.22*x1 + 0.14*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 75, "total_items_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coffees: {x1.x}")
    print(f"Hot Chocolates: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
