
import gurobipy as gp

# Create a new model
m = gp.Model("coffee_hot_chocolate")

# Define variables
x1 = m.addVar(name="coffees", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hot_chocolates", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
m.setObjective(0.22*x1 + 0.14*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 >= 40, name="min_coffees")
m.addConstr(x2 >= 20, name="min_hot_chocolates")
m.addConstr(x1 <= 60, name="max_coffees")
m.addConstr(x2 <= 35, name="max_hot_chocolates")
m.addConstr(x1 + x2 <= 75, name="total_items")

# Update model
m.update()

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Coffees: {x1.varValue}")
    print(f"Hot Chocolates: {x2.varValue}")
    print(f"Maximum Profit: {0.22*x1.varValue + 0.14*x2.varValue}")
else:
    print("No optimal solution found.")
