
import gurobipy as gp

# Create a new model
m = gp.Model("bubble_tea_optimization")

# Create variables
taro_tea = m.addVar(vtype=gp.GRB.CONTINUOUS, name="taro_tea")  # x1
mango_tea = m.addVar(vtype=gp.GRB.CONTINUOUS, name="mango_tea") # x2

# Set objective function
m.setObjective(4 * taro_tea + 6 * mango_tea, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * taro_tea <= 60, "taro_constraint")
m.addConstr(3 * mango_tea <= 60, "mango_constraint")
m.addConstr(4 * taro_tea + 5 * mango_tea <= 140, "milk_tea_constraint")
m.addConstr(taro_tea >= 0)
m.addConstr(mango_tea >= 0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Taro bubble teas: {taro_tea.x:.2f}")
    print(f"Mango bubble teas: {mango_tea.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

