
from gurobipy import *

# Create a new model
m = Model("Bubble_Tea_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="taro_bubble_teas")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mango_bubble_teas")

# Set the objective function
m.setObjective(4*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 <= 60, "taro_availability")
m.addConstr(3*x2 <= 60, "mango_availability")
m.addConstr(4*x1 + 5*x2 <= 140, "milk_availability")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of taro bubble teas: {x1.x}")
    print(f"Number of mango bubble teas: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
