
import gurobi

def solve_bubble_tea_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="taro_bubble_tea", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="mango_bubble_tea", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(4 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x1 <= 60, name="taro_constraint")
    model.addConstr(3 * x2 <= 60, name="mango_constraint")
    model.addConstr(4 * x1 + 5 * x2 <= 140, name="milk_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of taro bubble teas: {x1.varValue}")
        print(f"Number of mango bubble teas: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_bubble_tea_problem()
