
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Eli's Farming Optimization")

# Create variables
beans = m.addVar(name="beans")
pumpkins = m.addVar(name="pumpkins")

# Set objective function
m.setObjective(100 * beans + 110 * pumpkins, GRB.MAXIMIZE)

# Add constraints
m.addConstr(beans + pumpkins <= 100, "Total Acres")
m.addConstr(beans >= 5, "Min Beans")
m.addConstr(pumpkins >= 10, "Min Pumpkins")
m.addConstr(pumpkins <= 3 * beans, "Pumpkin to Bean Ratio")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {beans.x} acres of beans")
    print(f"Plant {pumpkins.x} acres of pumpkins")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

