
from gurobipy import *

# Create a new model
m = Model("Eli_Farm")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="acres_of_beans")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="acres_of_pumpkins")

# Set the objective function
m.setObjective(100*x1 + 110*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 5, "min_beans")
m.addConstr(x2 >= 10, "min_pumpkins")
m.addConstr(x1 + x2 <= 100, "total_acres")
m.addConstr(x2 <= 3*x1, "labor_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of beans: {x1.x}")
    print(f"Acres of pumpkins: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
