
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="beans")
    x2 = model.addVar(lb=0, name="pumpkins")

    # Set objective function
    model.setObjective(100 * x1 + 110 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 100, name="total_acres")
    model.addConstr(x1 >= 5, name="min_beans")
    model.addConstr(x2 >= 10, name="min_pumpkins")
    model.addConstr(x2 <= 3 * x1, name="labor_constraint")

    # Update model
    model.update()

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres of beans: {x1.varValue}")
        print(f"Optimal acres of pumpkins: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
