
import gurobipy as gp

# Create a new model
m = gp.Model("video_game_stock")

# Create variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="regular_games") # number of regular games
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="collectors_games") # number of collector's edition games

# Set objective function
m.setObjective(20*x1 + 30*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 50*x2 <= 4000, "cost_constraint") # Cost constraint
m.addConstr(x1 + x2 <= 100, "sales_constraint") # Sales constraint
m.addConstr(x1 >= 0, "nonnegativity_constraint_x1") # Non-negativity constraint
m.addConstr(x2 >= 0, "nonnegativity_constraint_x2") # Non-negativity constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of regular games to stock: {x1.x}")
    print(f"Number of collector's edition games to stock: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

