
from gurobipy import *

# Create a new model
m = Model("Video_Game_Store")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="regular_games", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="collectors_edition_games", lb=0)

# Set the objective function
m.setObjective(20*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 50*x2 <= 4000, "budget_constraint")
m.addConstr(x1 <= 100, "regular_games_limit")
m.addConstr(x2 <= 100, "collectors_edition_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular games: {x1.x}")
    print(f"Collector's edition games: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
