
import gurobipy as gp

# Create a new model
model = gp.Model("VideoGameStore")

# Define variables
x1 = model.addVar(name="regular_games", lb=0, vtype=gp.GRB.INTEGER)  # Number of regular games
x2 = model.addVar(name="collectors_edition_games", lb=0, vtype=gp.GRB.INTEGER)  # Number of collector's edition games

# Objective function: Maximize profit
model.setObjective(20*x1 + 30*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 100, name="total_games_sold")  # At most 100 games sold
model.addConstr(30*x1 + 50*x2 <= 4000, name="total_cost")  # Total cost not exceeding $4000

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {model.x[0]} regular games, {model.x[1]} collector's edition games")
    print(f"Max Profit: ${model.objVal}")
else:
    print("No optimal solution found")
