
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("console_production")

# Create decision variables
px7 = model.addVar(vtype=GRB.INTEGER, name="px7")
silent_x = model.addVar(vtype=GRB.INTEGER, name="silent_x")

# Set objective function
model.setObjective(40 * px7 + 75 * silent_x, GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * px7 + 7 * silent_x <= 48, "labor_constraint")
model.addConstr(px7 >= 2 * silent_x, "demand_constraint")
model.addConstr(px7 >= 0, "px7_nonnegativity")
model.addConstr(silent_x >= 0, "silent_x_nonnegativity")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of PX7 consoles to produce: {px7.x}")
    print(f"Number of Silent X consoles to produce: {silent_x.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

