
from gurobipy import *

# Create a new model
m = Model("console_production")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="px7_consoles", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="silent_x_consoles", lb=0)

# Set the objective function
m.setObjective(40*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 7*x2 <= 48, "labor_constraint")
m.addConstr(x1 >= 2*x2, "demand_forecast_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of PX7 consoles: {x1.x}")
    print(f"Number of Silent X consoles: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
