
import gurobi

def solve_production_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', obj=40, lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='x2', obj=75, lb=0, vtype=gurobi.GRB.INTEGER)

    # Add constraints
    model.addConstr(x1 >= 2 * x2, name='PX7_SilentX_ratio')
    model.addConstr(3 * x1 + 7 * x2 <= 48, name='Labor_hours_constraint')

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: {x1.x} PX7 consoles, {x2.x} Silent X consoles")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_production_problem()
