
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("glass_panes")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="bulletproof_panes") # Number of bulletproof panes
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="fire_rated_panes") # Number of fire-rated panes


# Set objective function
m.setObjective(12*x1 + 9.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 7*x2 <= 350, "heating_constraint")
m.addConstr(6*x1 + 9*x2 <= 350, "cooling_constraint")
m.addConstr(x1 >= 0, "non_negativity_x1")
m.addConstr(x2 >= 0, "non_negativity_x2")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution and objective value
    print(f"Optimal Solution:")
    print(f"Number of bulletproof glass panes: {x1.x}")
    print(f"Number of fire-rated glass panes: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")

