
from gurobipy import *

# Create a new model
model = Model("Glass_Production")

# Create variables
x1 = model.addVar(name='bulletproof_glass_panes', vtype=GRB.CONTINUOUS, lb=0)
x2 = model.addVar(name='fire_rated_glass_panes', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
model.setObjective(12*x1 + 9.5*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*x1 + 7*x2 <= 350, name='heating_machine_time')
model.addConstr(6*x1 + 9*x2 <= 350, name='cooling_machine_time')

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of bulletproof glass panes: {x1.x}")
    print(f"Number of fire-rated glass panes: {x2.x}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
