
import gurobi

def solve_alpha_glass_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="bulletproof_glass_panes", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="fire_rated_glass_panes", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 12*x1 + 9.5*x2
    model.setObjective(12*x1 + 9.5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x1 + 7*x2 <= 350, name="heating_machine_constraint")
    model.addConstr(6*x1 + 9*x2 <= 350, name="cooling_machine_constraint")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Number of bulletproof glass panes: {x1.varValue}, Number of fire-rated glass panes: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_alpha_glass_problem()
