
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
vegetables = m.addVar(lb=0, name="vegetables")  # Servings of vegetables
grains = m.addVar(lb=0, name="grains")  # Servings of grains

# Set objective function: Minimize cost
m.setObjective(0.6 * vegetables + 0.4 * grains, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15 * vegetables + 30 * grains >= 100, "iron_req")  # Iron requirement
m.addConstr(25 * vegetables + 5 * grains >= 150, "fiber_req")  # Fiber requirement


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Servings of vegetables: {vegetables.x}")
    print(f"Servings of grains: {grains.x}")
    print(f"Minimum cost: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

