
from gurobipy import *

# Create a new model
m = Model("food_groups")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="grains", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="vegetables", lb=0)

# Set the objective function
m.setObjective(0.40*x1 + 0.60*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(30*x1 + 15*x2 >= 100, "iron_requirement")
m.addConstr(5*x1 + 25*x2 >= 150, "fiber_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of servings of grains: {x1.x}")
    print(f"Number of servings of vegetables: {x2.x}")
    print(f"Total cost: ${0.40*x1.x + 0.60*x2.x:.2f}")
else:
    print("No optimal solution found")
